/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.ICarriageIndexSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowExitDirectionSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowNextConnections;
import de.mrjulsen.crn.block.display.properties.components.IShowTrainStatsSetting;
import de.mrjulsen.crn.block.display.properties.components.ITimeDisplaySetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainTextSetting;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PassengerInformationDetailedSettings
extends BasicDisplaySettings
implements ITimeDisplaySetting,
IShowTrainStatsSetting,
IShowExitDirectionSetting,
ICarriageIndexSetting,
IShowNextConnections,
ITrainTextSetting {
    protected ETimeDisplay timeDisplay = ETimeDisplay.ABS;
    protected boolean showStats = true;
    protected boolean showExit = true;
    protected boolean showConnections = true;
    protected byte carriageIndexOffset = 0;
    protected boolean overwriteCarriageIndex = false;
    protected ITrainTextSetting.ETrainTextComponents trainTextComponents = ITrainTextSetting.ETrainTextComponents.TRAIN_NAME;

    @Override
    public void deserializeNbt(CompoundTag nbt) {
        super.deserializeNbt(nbt);
        if (nbt.m_128441_("TimeDisplay")) {
            this.timeDisplay = ETimeDisplay.getById(nbt.m_128445_("TimeDisplay"));
        }
        if (nbt.m_128441_("ShowStats")) {
            this.showStats = nbt.m_128471_("ShowStats");
        }
        if (nbt.m_128441_("ShowExit")) {
            this.showExit = nbt.m_128471_("ShowExit");
        }
        if (nbt.m_128441_("ShowConnections")) {
            this.showConnections = nbt.m_128471_("ShowConnections");
        }
        if (nbt.m_128441_("CarriageIndexOffset")) {
            this.carriageIndexOffset = nbt.m_128445_("CarriageIndexOffset");
        }
        if (nbt.m_128441_("OverwriteCarriageIndex")) {
            this.overwriteCarriageIndex = nbt.m_128471_("OverwriteCarriageIndex");
        }
        if (nbt.m_128441_("TrainText")) {
            this.trainTextComponents = ITrainTextSetting.ETrainTextComponents.getById(nbt.m_128445_("TrainText"));
        }
    }

    @Override
    public void serializeNbt(CompoundTag nbt) {
        super.serializeNbt(nbt);
        nbt.m_128344_("TimeDisplay", this.timeDisplay.getId());
        nbt.m_128379_("ShowStats", this.showStats);
        nbt.m_128379_("ShowExit", this.showExit);
        nbt.m_128379_("ShowConnections", this.showConnections);
        nbt.m_128344_("CarriageIndexOffset", this.carriageIndexOffset);
        nbt.m_128379_("OverwriteCarriageIndex", this.overwriteCarriageIndex);
        nbt.m_128344_("TrainText", this.trainTextComponents.getId());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        this.buildTimeDisplayGui(context);
        this.buildShowStatsGui(context);
        this.buildShowExitGui(context);
        this.buildShowConnectionGui(context);
        this.buildCarriageIndexGui(context);
        this.buildTrainTextGui(context);
    }

    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        this.copyTimeDisplaySetting(oldSettings);
        this.copyShowExitSetting(oldSettings);
        this.copyShowStatsSetting(oldSettings);
        this.copyShowConnectionSetting(oldSettings);
        this.copyCarriageIndexSetting(oldSettings);
    }

    @Override
    public boolean showStats() {
        return this.showStats;
    }

    @Override
    public void setShowStats(boolean b) {
        this.showStats = b;
    }

    @Override
    public boolean showExit() {
        return this.showExit;
    }

    @Override
    public void setShowExit(boolean b) {
        this.showExit = b;
    }

    @Override
    public boolean showConnections() {
        return this.showConnections;
    }

    @Override
    public void setShowConnection(boolean b) {
        this.showConnections = b;
    }

    @Override
    public byte getCarriageIndex() {
        return this.carriageIndexOffset;
    }

    @Override
    public boolean shouldOverwriteCarriageIndex() {
        return this.overwriteCarriageIndex;
    }

    @Override
    public void setCarriageIndex(byte b) {
        this.carriageIndexOffset = b;
    }

    @Override
    public void setOverwriteCarriageIndex(boolean b) {
        this.overwriteCarriageIndex = b;
    }

    @Override
    public ETimeDisplay getTimeDisplay() {
        return this.timeDisplay;
    }

    @Override
    public void setTimeDisplay(ETimeDisplay display) {
        this.timeDisplay = display;
    }

    @Override
    public ITrainTextSetting.ETrainTextComponents getTrainTextComponents() {
        return this.trainTextComponents;
    }

    @Override
    public void setTrainTextComponents(ITrainTextSetting.ETrainTextComponents v) {
        this.trainTextComponents = v;
    }
}

